#include <stdio.h>

#include "parser.h"
#include "searcher.h"
#include "sgrep_data.h"

enum {MATCH, NO_MATCH, PROGRAM_FAILURE};

int main(int argc, char **argv) {
  
  sgrep_data sgd;
  int ret = 0;
  
  ret = parse(argc-1, ++argv, &sgd);
  
  if (ret == PARSE_BAD_INDATA)
    return PROGRAM_FAILURE;
         
  /* printf ("Case sensitive: %d\n", */
  /*         sgd.case_sensitive); */
  /* printf ("match count: %d\n", */
  /*         sgd.match_count); */
  /* printf ("line numbers: %d\n", */
  /*         sgd.line_number_mode); */
  
  /* printf("reg_exp : %s\n", sgd.reg_exp); */
  
  
  /* Searcher: Call search_file */
  ret = search_file(&sgd);
  
  if (ret == SEARCHER_OK_MATCHES)
    return MATCH;
  
  else if (ret == SEARCHER_OK_NO_MATCHES)
    return NO_MATCH;
  
  else if (ret == 2)
    return PROGRAM_FAILURE;
}


